/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import svenhjol.meson.MesonTile;

public abstract class MesonTileInventory
extends MesonTile {
    protected String lootTable;
    protected int lootSize;

    public abstract ItemStackHandler getInventory();

    public abstract int getInventorySize();

    public void generateLoot(@Nullable EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && this.hasLootTable()) {
            int i;
            ResourceLocation res = new ResourceLocation(this.lootTable);
            LootTable table = this.field_145850_b.func_184146_ak().func_186521_a(res);
            LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da());
            }
            LootContext context = builder.func_186471_a();
            List<ItemStack> list = this.generateLootForPools(table, this.field_145850_b.field_73012_v, context);
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (i = 0; i < this.getInventorySize(); ++i) {
                slots.add(i);
            }
            Collections.shuffle(slots);
            i = 0;
            for (ItemStack item : list) {
                if (i >= this.getInventorySize()) continue;
                this.getInventory().setStackInSlot(((Integer)slots.get(i++)).intValue(), item);
            }
            this.lootTable = null;
            this.lootSize = 0;
        }
    }

    protected List<ItemStack> generateLootForPools(LootTable table, Random rand, LootContext context) {
        List loot = table.func_186462_a(rand, context);
        if (this.lootSize > 0) {
            int i = 0;
            while (loot.size() < this.lootSize && i++ < 10) {
                loot.addAll(table.func_186462_a(rand, context));
            }
            if (loot.size() > this.lootSize) {
                loot = loot.subList(0, this.lootSize);
            }
        }
        return loot;
    }

    public int getComparatorOutput() {
        float f = 0.0f;
        int i = 0;
        ItemStackHandler inventory = this.getInventory();
        for (int slot = 0; slot < this.getInventorySize(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            f += (float)stack.func_190916_E() / (float)Math.min(inventory.getSlotLimit(slot), stack.func_77976_d());
            ++i;
        }
        return MathHelper.func_76128_c((double)((double)(f /= (float)this.getInventorySize()) * 14.0)) + (i > 0 ? 1 : 0);
    }

    @Override
    public void readTag(NBTTagCompound tag) {
        super.readTag(tag);
        this.getInventory().deserializeNBT(tag.func_74775_l("inventory"));
        this.setLootTable(tag.func_74779_i("lootTable"));
        this.setLootSize(tag.func_74762_e("lootSize"));
    }

    @Override
    public void writeTag(NBTTagCompound tag) {
        super.writeTag(tag);
        tag.func_74782_a("inventory", (NBTBase)this.getInventory().serializeNBT());
        tag.func_74768_a("lootSize", this.getLootSize());
        tag.func_74778_a("lootTable", this.getLootTable());
    }

    public boolean hasLootTable() {
        return this.lootTable != null && !this.lootTable.isEmpty();
    }

    public String getLootTable() {
        return this.hasLootTable() ? this.lootTable : "";
    }

    public void setLootTable(ResourceLocation lootTable) {
        this.lootTable = lootTable.toString();
    }

    public void setLootTable(ResourceLocation lootTable, int lootSize) {
        this.setLootTable(lootTable.toString(), lootSize);
    }

    public void setLootTable(ResourceLocation lootTable, long seed) {
        this.setLootTable(lootTable.toString());
    }

    public void setLootTable(String lootTable) {
        this.lootTable = lootTable;
    }

    public void setLootTable(String lootTable, int lootSize) {
        this.setLootTable(lootTable);
        this.setLootSize(lootSize);
    }

    public int getLootSize() {
        return this.lootSize;
    }

    public void setLootSize(int size) {
        this.lootSize = size;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.getInventory() : super.getCapability(capability, facing));
    }
}

